/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.log;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.log.LogAttributes;
import com.ibm.hwmca.fw.log.LogBlock;
import com.ibm.hwmca.fw.log.LogBlockFilter;
import com.ibm.hwmca.fw.log.LogEntryId;
import com.ibm.hwmca.fw.log.LoggerTasklet;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.tasklet.Client;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.tasklet.TaskletRequest;
import com.ibm.hwmca.fw.tasklet.TaskletResponse;
import com.ibm.hwmca.fw.util.ObjectDumper;
import com.ibm.hwmca.fw.util.ObjectDumperAttributes;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Date;
import java.util.Iterator;

public class Logger {
    public static final int FULL_TRACE = 1;
    public static final int PROCESS_TRACE = 2;
    public static final int THREAD_TRACE = 3;
    public static final int ALT_TRACE = 4;
    private static Logger logger = new Logger();
    private static final ObjectDumper objectDumper = new ObjectDumper();
    private static Object monitor = new Object();
    private static final String TRACE_MASKT = "XFRMLGRT";
    private static final String TRACE_MASKF = "XFRMLGRF";
    private static final String TRACE_MASKD = "XFRMLGRD";
    private boolean local;
    private Client taskletClient = null;
    private LoggerTasklet tasklet = null;

    private Logger() {
        boolean bl = this.local = CommonSystem.getCommonSystem().isLocationUnified() || CommonSystem.getCommonSystem().isLocationServer();
        if (this.local) {
            this.tasklet = new LoggerTasklet();
        }
        try {
            if (!this.local) {
                this.taskletClient = new Client("com.ibm.hwmca.fw.log.LoggerTasklet", null);
                this.taskletClient.init();
            }
        }
        catch (TaskletException exc) {
            Trace.trace(TRACE_MASKF, "Exception caught trying to create the logger tasklet client");
            Trace.trace(TRACE_MASKF, exc);
        }
    }

    public static Logger getLogger() {
        return logger;
    }

    public void finalize() {
        if (this.taskletClient != null) {
            this.taskletClient.terminate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogEntryId log(Log log, LogAttributes attribs) throws HException {
        Trace.trace(TRACE_MASKT, "-> log()");
        LogEntryId result = null;
        Log logClone = (Log)log.clone();
        Iterator logBlocks = logClone.dataBlocks.iterator();
        while (logBlocks.hasNext()) {
            LogBlock logBlock = (LogBlock)logBlocks.next();
            byte blockId = logBlock.getBlockId();
            Object blockData = logBlock.getData();
            if (blockData instanceof byte[] || blockData instanceof String) continue;
            ObjectDumperAttributes dumpAttribs = logBlock.getDumpAttributes();
            logBlock.setData(objectDumper.dumpObject(blockData, dumpAttribs));
        }
        TaskletResponse response = null;
        TaskletRequest request = new TaskletRequest();
        request.setData("Action", "log");
        request.setData("Log", logClone);
        request.setData("LogAttributes", attribs);
        if (this.local) {
            response = new TaskletResponse();
            this.tasklet.service(request, response);
            result = (LogEntryId)response.getData("LogEntryId");
        } else if (this.taskletClient != null) {
            Object object = monitor;
            synchronized (object) {
                response = this.taskletClient.request(request);
            }
            result = (LogEntryId)response.getData("LogEntryId");
        }
        Trace.trace(TRACE_MASKT, "<- log()");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Log[] retrieve(Byte logClass, Byte logType, Short user, Date startTime, Date endTime, LogBlockFilter[] logBlockFilters, byte[] logBlockIds, Integer eventCount, String logId) throws HException {
        Trace.trace(TRACE_MASKT, "-> retrieve()");
        Log[] result = null;
        TaskletResponse response = null;
        TaskletRequest request = new TaskletRequest();
        request.setData("Action", "retrieve");
        request.setData("LogClass", logClass);
        request.setData("LogType", logType);
        request.setData("User", user);
        request.setData("StartTime", startTime);
        request.setData("EndTime", endTime);
        request.setData("LogBlockFilters", logBlockFilters);
        request.setData("LogBlockIds", logBlockIds);
        request.setData("EventCount", eventCount);
        request.setData("LogId", logId);
        if (this.local) {
            response = new TaskletResponse();
            this.tasklet.service(request, response);
            result = (Log[])response.getData("Logs");
        } else if (this.taskletClient != null) {
            Object object = monitor;
            synchronized (object) {
                response = this.taskletClient.request(request);
            }
            result = (Log[])response.getData("Logs");
        } else {
            throw new HException("Error creating logger tasklet client");
        }
        Trace.trace(TRACE_MASKT, "<- retrieve()");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Log[] retrieve(Byte[] logClasses, Byte logType, Date startTime, Date endTime, String logId) throws HException {
        Trace.trace(TRACE_MASKT, "-> retrieve()");
        Log[] result = null;
        TaskletResponse response = null;
        TaskletRequest request = new TaskletRequest();
        request.setData("Action", "multiRetrieve");
        request.setData("LogClasses", logClasses);
        request.setData("LogType", logType);
        request.setData("StartTime", startTime);
        request.setData("EndTime", endTime);
        request.setData("LogId", logId);
        if (this.local) {
            response = new TaskletResponse();
            this.tasklet.service(request, response);
            result = (Log[])response.getData("Logs");
        } else if (this.taskletClient != null) {
            Object object = monitor;
            synchronized (object) {
                response = this.taskletClient.request(request);
            }
            result = (Log[])response.getData("Logs");
        } else {
            throw new HException("Error creating logger tasklet client");
        }
        Trace.trace(TRACE_MASKT, "<- retrieve()");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Log[] retrieve(Byte[] logClasses, Byte logType, Short user, Date startTime, Date endTime, String logId, Long offset, Long count, Long options) throws HException {
        Trace.trace(TRACE_MASKT, "-> retrieveSpan()");
        Log[] result = null;
        TaskletResponse response = null;
        TaskletRequest request = new TaskletRequest();
        request.setData("Action", "retrieveSpan");
        request.setData("LogClasses", logClasses);
        request.setData("LogType", logType);
        request.setData("User", user);
        request.setData("StartTime", startTime);
        request.setData("EndTime", endTime);
        request.setData("LogId", logId);
        request.setData("Offset", offset);
        request.setData("Count", count);
        request.setData("Options", options);
        Trace.trace(TRACE_MASKT, "retrieveSpan() count = " + count + ", options = 0x" + Long.toHexString(options));
        if (this.local) {
            response = new TaskletResponse();
            this.tasklet.service(request, response);
            result = (Log[])response.getData("Logs");
        } else if (this.taskletClient != null) {
            Object object = monitor;
            synchronized (object) {
                response = this.taskletClient.request(request);
            }
            result = (Log[])response.getData("Logs");
        } else {
            throw new HException("Error creating logger tasklet client");
        }
        Trace.trace(TRACE_MASKT, "<- retrieveSpan()");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Log[] retrieveSummary(Byte[] logClasses, Byte logType, Date startTime, Date endTime, String logId, Integer forceGet) throws HException {
        Trace.trace(TRACE_MASKT, "-> retrieveSummary()");
        Log[] result = null;
        TaskletResponse response = null;
        TaskletRequest request = new TaskletRequest();
        request.setData("Action", "multiRetrieveSummary");
        request.setData("LogClasses", logClasses);
        request.setData("LogType", logType);
        request.setData("StartTime", startTime);
        request.setData("EndTime", endTime);
        request.setData("LogId", logId);
        request.setData("ForceGet", forceGet);
        if (this.local) {
            response = new TaskletResponse();
            this.tasklet.service(request, response);
            result = (Log[])response.getData("Logs");
        } else if (this.taskletClient != null) {
            Object object = monitor;
            synchronized (object) {
                response = this.taskletClient.request(request);
            }
            result = (Log[])response.getData("Logs");
        }
        Trace.trace(TRACE_MASKT, "<- retrieveSummary()");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateModifyBlock(LogEntryId logEntryId, byte[] newValue) throws HException {
        Trace.trace(TRACE_MASKT, "-> updateModifyBlock()");
        TaskletRequest request = new TaskletRequest();
        request.setData("Action", "updateModifyBlock");
        request.setData("LogEntryId", logEntryId);
        request.setData("NewValue", newValue);
        if (this.local) {
            TaskletResponse response = new TaskletResponse();
            this.tasklet.service(request, response);
        } else if (this.taskletClient != null) {
            Object object = monitor;
            synchronized (object) {
                this.taskletClient.request(request);
            }
        }
        Trace.trace(TRACE_MASKT, "<- updateModifyBlock()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTrace(int bufferId) throws HException {
        Trace.trace(TRACE_MASKD, "-> getTrace()");
        String result = null;
        TaskletResponse response = null;
        TaskletRequest request = new TaskletRequest();
        request.setData("Action", "getTrace");
        request.setData("BufferId", new Integer(bufferId));
        if (this.local) {
            response = new TaskletResponse();
            this.tasklet.service(request, response);
            result = (String)response.getData("Buffer");
        } else if (this.taskletClient != null) {
            Object object = monitor;
            synchronized (object) {
                response = this.taskletClient.request(request);
            }
            result = (String)response.getData("Buffer");
        }
        if (result == null) {
            result = "";
        }
        Trace.trace(TRACE_MASKD, "<- getTrace()");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTraces(int[] bufferIds) throws HException {
        Trace.trace(TRACE_MASKD, "-> getTraces()");
        String[] result = null;
        TaskletResponse response = null;
        TaskletRequest request = new TaskletRequest();
        request.setData("Action", "getTraces");
        request.setData("BufferIds", bufferIds);
        if (this.local) {
            response = new TaskletResponse();
            this.tasklet.service(request, response);
            result = (String[])response.getData("Buffers");
        } else if (this.taskletClient != null) {
            Object object = monitor;
            synchronized (object) {
                response = this.taskletClient.request(request);
            }
            result = (String[])response.getData("Buffers");
        }
        if (result == null) {
            result = new String[]{};
        }
        Trace.trace(TRACE_MASKD, "<- getTraces()");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogBlock[] getLogBlocks(int jniDataBlocks) throws HException {
        Trace.trace(TRACE_MASKD, "-> getLogBlocks()");
        LogBlock[] result = null;
        TaskletResponse response = null;
        TaskletRequest request = new TaskletRequest();
        request.setData("Action", "getLogBlocks");
        request.setData("JniDataBlocks", new Integer(jniDataBlocks));
        if (this.local) {
            response = new TaskletResponse();
            this.tasklet.service(request, response);
            result = (LogBlock[])response.getData("LogBlocks");
        } else if (this.taskletClient != null) {
            Object object = monitor;
            synchronized (object) {
                response = this.taskletClient.request(request);
            }
            result = (LogBlock[])response.getData("LogBlocks");
        } else {
            throw new HException("Error creating logger tasklet client");
        }
        Trace.trace(TRACE_MASKD, "<- getLogBlocks()");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getLogHeader(String logId) throws HException {
        Trace.trace(TRACE_MASKD, "-> getLogHeader()");
        byte[] result = null;
        TaskletRequest request = new TaskletRequest();
        TaskletResponse response = null;
        request.setData("Action", "getLogHeader");
        request.setData("LogId", logId);
        if (this.local) {
            response = new TaskletResponse();
            this.tasklet.service(request, response);
            result = (byte[])response.getData("LogHeader");
        } else if (this.taskletClient != null) {
            Object object = monitor;
            synchronized (object) {
                response = this.taskletClient.request(request);
            }
            result = (byte[])response.getData("LogHeader");
        } else {
            throw new HException("Error creating logger tasklet client");
        }
        Trace.trace(TRACE_MASKD, "<- getLogHeader()");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementRefCount(int jniDataBlocks) throws HException {
        Trace.trace(TRACE_MASKD, "-> incrementRefCount()");
        TaskletRequest request = new TaskletRequest();
        request.setData("Action", "incrementRefCount");
        request.setData("JniDataBlocks", new Integer(jniDataBlocks));
        if (this.local) {
            TaskletResponse response = new TaskletResponse();
            this.tasklet.service(request, response);
        } else if (this.taskletClient != null) {
            Object object = monitor;
            synchronized (object) {
                this.taskletClient.request(request);
            }
        }
        Trace.trace(TRACE_MASKD, "<- incrementRefCount()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void free(int jniDataBlocks) throws HException {
        Trace.trace(TRACE_MASKD, "-> free()");
        TaskletRequest request = new TaskletRequest();
        request.setData("Action", "free");
        request.setData("JniDataBlocks", new Integer(jniDataBlocks));
        if (this.local) {
            TaskletResponse response = new TaskletResponse();
            this.tasklet.service(request, response);
        } else if (this.taskletClient != null) {
            Object object = monitor;
            synchronized (object) {
                this.taskletClient.request(request);
            }
        }
        Trace.trace(TRACE_MASKD, "<- free()");
    }
}

